import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Color;
import java.awt.Font;
import java.io.*;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Write a description of class Rekeningen here.
 *
 * Jozef Aerts
 *
 * 23/06/2016
 */

public class RekeningenBasis extends JFrame {

    private JLabel HoofdLabel = new JLabel(" Welkom tot Jozef Aerts Rekeningen");
    private JLabel AantalBewerkingen = new JLabel(" Aantal Bewerkingen");
     
    private JButton buttonOKAlgemeen = new JButton("OK");
    private JButton buttonOKStatistiek = new JButton("OK voor Statistiek");
    
    private JRadioButton optiondefault = new JRadioButton("");
    private JRadioButton optionNieuweBewerking = new JRadioButton("Nieuwe Bewerking");
    private JRadioButton optionOverzichtBewerkingen = new JRadioButton("Overzicht Bewerkingen");
    private JRadioButton optionStandRekening = new JRadioButton("Stand Rekening");
    private JRadioButton optionStatistiek = new JRadioButton("Statistiek");
    
    private JRadioButton optionHoogsteInkomst = new JRadioButton("Hoogste Inkomst");
    private JRadioButton optionHoogsteUitgave = new JRadioButton("Hoogste Uitgave");
    private JRadioButton optionHoogsteRekeningStand = new JRadioButton("Hoogste Rekeningstand");
    private JRadioButton optionSortBedrag = new JRadioButton("Sorteren van Bedrag ");
    private JRadioButton optionSortTotaal = new JRadioButton("Sorteren van Totaal Bedrag ");
    
    
    private String[] Bedrag = {"Bedrag","0"};
    private String[] Beschrijving = {"Beschrijving", "Loon", "Electriciteit", "Verwarming", "Telecommunicatie", "Kleding", "Voeding", "Ontspanning", "Lening", "Gezondheid", "Huur", "School", "Sport"};
    private String[] Dag = {"Dag", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private String[] Maand = {"Maand", "Januari", "Februari", "Maart", "April", "Mei", "Juni", "Juli", "Augustus", "September", "Oktober", "November", "December"};
    private String[] Jaar = {"Jaar", "2016", "2017", "2018", "2019", "2020"};
    
    private JComboBox InputBeschrijving = new JComboBox(Beschrijving);
    private JComboBox InputBedrag = new JComboBox(Bedrag);
    private JComboBox InputDag = new JComboBox(Dag);
    private JComboBox InputMaand = new JComboBox(Maand);
    private JComboBox InputJaar = new JComboBox(Jaar);
    
    private ArrayList<String> AlleDag = new ArrayList<String> ();
    private ArrayList<String> AlleMaand = new ArrayList<String> ();
    private ArrayList<String> AlleJaar = new ArrayList<String> ();
    private ArrayList<String> AlleBeschrijving = new ArrayList<String> ();
    private ArrayList<String> AlleBedrag = new ArrayList<String> ();
    private ArrayList<String> AlleVorigTotaal = new ArrayList<String> ();
    private ArrayList<String> AlleNieuwTotaal = new ArrayList<String> ();

    

  
    private String VorigTotaalString , NieuwTotaalString , gegeven_BedragString;
    private double VorigTotaal, NieuwTotaal , gegeven_Bedrag;
   
    private String gegeven_Beschrijving , gegeven_Maand, gegeven_Dag, gegeven_Jaar;
    private Scanner RekeningGegevensLezen, StandRekeningLezen;
    private FileWriter RekeningGegevensSchrijven, StandRekeningSchrijven;
    private int teller ;

    public void OpenRekeningenBestandLezen (){
    try { RekeningGegevensLezen = new Scanner ( new File ("RekeningGegevens.txt" ));}
    catch (Exception e ) {
        System.out.println(" File RekeningGegevens.txt niet gevonden ");    }
    }
    
    public void OpenStandRekeningLezen (){
    try { StandRekeningLezen = new Scanner ( new File ("StandRekening.txt" ));}
    catch (Exception e ) {
        System.out.println(" File StandRekening.txt niet gevonden ");    }
    }
      
    public void OpenRekeningenBestandSchrijven (){
    try { RekeningGegevensSchrijven = new FileWriter ( "RekeningGegevens.txt", true );}
    catch (Exception e ) {
        System.out.println(" File RekeningGegevens.txt niet gevonden ");    }
    }
    
    public void OpenStandRekeningSchrijven (){
    try { StandRekeningSchrijven = new FileWriter ( "StandRekening.txt");}
    catch (Exception e ) {
        System.out.println(" File StandRekening.txt niet gevonden ");    }
    }
 
       
    public void LeesRekeningenVanBestand () {
        OpenRekeningenBestandLezen ();
        System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++");
        System.out.println(" Vorig Totaal   Dag    Maand     Jaar        Beschrijving        Bedrag          Nieuw Totaal");
        while (RekeningGegevensLezen.hasNext()){
            String VorigTotaalBestand = RekeningGegevensLezen.next();
            String DagBestand = RekeningGegevensLezen.next();
            String MaandBestand = RekeningGegevensLezen.next();
            String JaarBestand = RekeningGegevensLezen.next();
            String BeschrijvingBestand = RekeningGegevensLezen.next();
            String BedragBestand = RekeningGegevensLezen.next();
            String NieuwTotaalBestand = RekeningGegevensLezen.next();
            System.out.format( " %12s | %2s | %9s | %4s | %19s | %12s € | %12s €%n" , VorigTotaalBestand , DagBestand , MaandBestand , JaarBestand , BeschrijvingBestand , BedragBestand , NieuwTotaalBestand);
            System.out.println("------------------------------------------------------------------------------");
        }
        System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++");
        RekeningGegevensLezen.close();
    }
    
    public void LeesRekeningenVanBestandNaarArray ()
    {
        OpenRekeningenBestandLezen ();
        teller = 1 ;
        
        while (RekeningGegevensLezen.hasNext()){
            AlleVorigTotaal.add (RekeningGegevensLezen.next());
            AlleDag.add (RekeningGegevensLezen.next());
            AlleMaand.add (RekeningGegevensLezen.next());
            AlleJaar.add (RekeningGegevensLezen.next());
            AlleBeschrijving.add (RekeningGegevensLezen.next());
            AlleBedrag.add (RekeningGegevensLezen.next());
            AlleNieuwTotaal.add (RekeningGegevensLezen.next());
            teller = teller + 1;
            
            
        }
        RekeningGegevensLezen.close();
    }
    
    public void SchrijfRekeningenNaarBestand () 
    { 
        OpenRekeningenBestandSchrijven ();
        
       
        try {  RekeningGegevensSchrijven.write(VorigTotaalString+" ");
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.write(gegeven_Dag+" ");
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.write(gegeven_Maand+" ");
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.write(gegeven_Jaar+" ");
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.write(gegeven_Beschrijving+" ");
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.write(gegeven_BedragString+" ");
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.write(NieuwTotaalString+" ");
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.flush();
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
        try {  RekeningGegevensSchrijven.close();
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
    }
    
    public void LeesRekeningStandVanBestand () {
        OpenStandRekeningLezen ();
        while (StandRekeningLezen.hasNext()){
            String NieuwTotaalBestand = StandRekeningLezen.next();
            NieuwTotaal = Double.parseDouble (NieuwTotaalBestand);
            VorigTotaal = NieuwTotaal; }
            StandRekeningLezen.close();
        }
    
    public void SchrijfRekeningStandNaarBestand () 
    { 
        OpenStandRekeningSchrijven ();
        
       
       try {  StandRekeningSchrijven.write(NieuwTotaalString);
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
       try {  StandRekeningSchrijven.close();
        } catch (IOException ex) {  Logger.getLogger(RekeningenBasis.class.getName()).log(Level.SEVERE, null, ex);   }
    }
  
    public RekeningenBasis() {
        super("Rekeningen Basis");
        VorigTotaal = 0;
        NieuwTotaal = 0;
        LeesRekeningStandVanBestand();
        ButtonGroup Hoofdgroup = new ButtonGroup();
        Hoofdgroup.add(optionNieuweBewerking);
        Hoofdgroup.add(optionOverzichtBewerkingen);
        Hoofdgroup.add(optionStandRekening);
        Hoofdgroup.add(optionStatistiek);
        optionNieuweBewerking.setSelected(true);

        setLayout(new FlowLayout());
        add(HoofdLabel);
        add(optionNieuweBewerking);
        add(optionOverzichtBewerkingen);
        add(optionStandRekening);
        add(optionStatistiek);
        add(buttonOKAlgemeen);

        RadioButtonActionListener actionListener = new RadioButtonActionListener();
        optionNieuweBewerking.addActionListener(actionListener);
        optionOverzichtBewerkingen.addActionListener(actionListener);
        optionStandRekening.addActionListener(actionListener);
        optionStatistiek.addActionListener(actionListener);

        /*
         * Actie zal gebeuren als je op de Algemene OK knop drukt
         */
        buttonOKAlgemeen.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent event) {
                String selectedOption = "";
                /*
                 * Nieuwe Bewerking Toevoegen
                 */
                if (optionNieuweBewerking.isSelected()) {
                    selectedOption = "nieuwe bewerking";
                                       
                    setLayout(new FlowLayout());
                    remove(optionNieuweBewerking); revalidate();   repaint();
                    remove(optionOverzichtBewerkingen); revalidate();  repaint();
                    remove(optionStandRekening); revalidate();  repaint();
                    remove(optionStatistiek); revalidate();  repaint();
                    remove(buttonOKAlgemeen); revalidate();  repaint();
                  
                    InputBedrag.setForeground(Color.RED);
                    InputBedrag.setFont(new Font("Arial", Font.BOLD, 10));
                    InputBedrag.setEditable(true);
                    add(InputBedrag);  revalidate(); repaint();
                    
                    InputDag.setForeground(Color.RED);
                    InputDag.setFont(new Font("Arial", Font.BOLD, 10));
                    InputDag.setEditable(true);
                    add(InputDag); revalidate();  repaint();
                    
                    InputMaand.setForeground(Color.RED);
                    InputMaand.setFont(new Font("Arial", Font.BOLD, 10));
                    InputMaand.setEditable(true);
                    add(InputMaand); revalidate();  repaint();
                    
                    InputJaar.setForeground(Color.RED);
                    InputJaar.setFont(new Font("Arial", Font.BOLD, 10));
                    InputJaar.setEditable(true);
                    add(InputJaar); revalidate();  repaint();  
                    
                    InputBeschrijving.setForeground(Color.RED);
                    InputBeschrijving.setFont(new Font("Arial", Font.BOLD, 10));
                    InputBeschrijving.setEditable(true);
                    add(InputBeschrijving); revalidate();  repaint();      
                   
                    InputDag.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent event) {
                          
                            JComboBox InputDag = (JComboBox) event.getSource();
                            gegeven_Dag = (String) InputDag.getSelectedItem();
                           ;                                                    
                        }
                    });
                    InputMaand.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent event) {
                          
                            JComboBox InputMaand = (JComboBox) event.getSource();
                            gegeven_Maand = (String) InputMaand.getSelectedItem();
                           ;                                                    
                        }
                    });
                    InputJaar.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent event) {
                          
                            JComboBox InputJaar = (JComboBox) event.getSource();
                            gegeven_Jaar = (String) InputJaar.getSelectedItem();
                           ;                                                    
                        }
                    });
                    InputBeschrijving.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent event) {
                           
                            JComboBox InputBeschrijving = (JComboBox) event.getSource();
                            gegeven_Beschrijving = (String) InputBeschrijving.getSelectedItem();
                            
                            NieuwTotaal = VorigTotaal + gegeven_Bedrag;
                            VorigTotaalString = Double.toString(VorigTotaal);
                            NieuwTotaalString = Double.toString(NieuwTotaal);
                           
                            System.out.format( " %12s € | %2s | %9s | %4s | %19s | %12s € %12s €%n" , VorigTotaalString , gegeven_Dag , gegeven_Maand , gegeven_Jaar , gegeven_Beschrijving , gegeven_Bedrag , NieuwTotaalString);
                            System.out.println("--------------------------------------------------------------------------------------------------------");
                            SchrijfRekeningenNaarBestand ();
                            SchrijfRekeningStandNaarBestand ();
                            VorigTotaal = NieuwTotaal;
                                                                                }
                    });
                        InputBedrag.addActionListener(new ActionListener() {
                        @Override
                        public void actionPerformed(ActionEvent event) {
                          
                            JComboBox InputBedrag = (JComboBox) event.getSource();
                            gegeven_BedragString = (String) InputBedrag.getSelectedItem(); 
                            gegeven_Bedrag = Double.parseDouble(gegeven_BedragString);
                        }
                    });
                }
                else {
                    
                    if(optionOverzichtBewerkingen.isSelected()){
                    LeesRekeningenVanBestandNaarArray();
                    System.out.println("  Vorig Totaal    Dag     Maand   Jaar        Beschrijving        Bedrag          Nieuw Totaal");
                    for ( int i =0 ;i < AlleBedrag.size() ; i++)
                    System.out.format( " %12s € | %2s | %9s | %4s | %19s | %12s € | %12s €%n" ,
                    AlleVorigTotaal.get(i),
                    AlleDag.get(i),
                    AlleMaand.get(i),
                    AlleJaar.get(i),
                    AlleBeschrijving.get(i),
                    AlleBedrag.get(i),
                    AlleNieuwTotaal.get(i));
                    System.out.println("--------------------------------------------------------------------------------------------------------");
                    
                    }
                
                    else {
                    if(optionStandRekening.isSelected()){
                        System.out.println("De huidige stand van de rekening is " + NieuwTotaal + " €");
                    }
                
                    else {
                    if(optionStatistiek.isSelected()){
                        LeesRekeningenVanBestandNaarArray();
                        selectedOption = "Nieuwe Bewerking";
                        
                        setLayout(new FlowLayout());
                        remove(optionNieuweBewerking); revalidate();   repaint();
                        remove(optionOverzichtBewerkingen); revalidate();  repaint();
                        remove(optionStandRekening); revalidate();  repaint();
                        remove(optionStatistiek); revalidate();  repaint();
                        remove(buttonOKAlgemeen); revalidate();  repaint();
                        
                        ButtonGroup Statistiekgroup = new ButtonGroup();
                        Statistiekgroup.add(optionHoogsteInkomst);
                        Statistiekgroup.add(optionHoogsteUitgave);
                        Statistiekgroup.add(optionHoogsteRekeningStand);
                        Statistiekgroup.add(optionSortBedrag);
                        Statistiekgroup.add(optionSortTotaal);
                        
                        add(optionHoogsteInkomst);
                        add(optionHoogsteUitgave);
                        add(optionHoogsteRekeningStand);
                        add(optionSortBedrag);
                        add(optionSortTotaal);
                        add(AantalBewerkingen);
                        InputBeschrijving.setForeground(Color.RED);
                        InputBeschrijving.setFont(new Font("Arial",Font.BOLD, 10));
                        InputBeschrijving.setEditable(true);
                        add(InputBeschrijving); revalidate(); repaint();
                        add(buttonOKStatistiek);
                        
                        RadioButtonActionListener actionListener = new RadioButtonActionListener();
                        optionHoogsteUitgave.addActionListener(actionListener);
                        optionHoogsteInkomst.addActionListener(actionListener);
                        optionHoogsteRekeningStand.addActionListener(actionListener);
                        InputBeschrijving.addActionListener(new ActionListener() {
                            @Override
                            public void actionPerformed(ActionEvent event){
                                JComboBox InputBeschrijving = (JComboBox) event.getSource();
                                gegeven_Beschrijving = (String) InputBeschrijving.getSelectedItem();
                                System.out.println("De bewerkingen voor " + gegeven_Beschrijving+ " zijn: ");
                                for ( int i=0 ;i <AlleBeschrijving.size(); i++){
                                    if(gegeven_Beschrijving.equals(AlleBeschrijving.get(i))) {
                                        System.out.format( " %12s € | %2s | %9s | %4s | %19s | %12s € | %12s €%n" ,
                                        AlleVorigTotaal.get(i),
                                        AlleDag.get(i),
                                        AlleMaand.get(i),
                                        AlleJaar.get(i),
                                        AlleBeschrijving.get(i),
                                        AlleBedrag.get(i),
                                        AlleNieuwTotaal.get(i));
                                        System.out.println("--------------------------------------------------------------------------------------------------------");
                                    }}
                                    System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                                }
                            });
                            buttonOKStatistiek.addActionListener(new ActionListener(){
                                @Override
                                public void actionPerformed(ActionEvent event) {
                                    String selectedOption="";
                                    
                                    if (optionHoogsteUitgave.isSelected()){
                                        
                                        int index_max_bedrag = 0;
                                        double max_bedrag = Double.parseDouble(AlleBedrag.get(0));
                                        double bedrag = Double.parseDouble(AlleBedrag.get(0));
                                        for(int i =0 ;i <AlleBedrag.size() ; i++){
                                            bedrag = Double.parseDouble(AlleBedrag.get(i));
                                            if(bedrag < max_bedrag){
                                                max_bedrag = bedrag;
                                                index_max_bedrag = i;
                                            }
                                        }
                                        System.out.println("Het grootste uitgegeven bedrag =");
                                        System.out.println("------------------------------------------------------");
                                        System.out.format(" %12s € | %2s | %9s | %4s | %19s | %12s € | %12s €%n" ,
                                        AlleVorigTotaal.get(index_max_bedrag),
                                        AlleDag.get(index_max_bedrag),
                                        AlleMaand.get(index_max_bedrag),
                                        AlleJaar.get(index_max_bedrag),
                                        AlleBeschrijving.get(index_max_bedrag),
                                        AlleBedrag.get(index_max_bedrag),
                                        AlleNieuwTotaal.get(index_max_bedrag));
                                    }
                                    else
                                    {
                                        if (optionHoogsteInkomst.isSelected()) {
                                            int index_max_bedrag = 0 ;
                                            double max_bedrag = Double.parseDouble(AlleBedrag.get(0));
                                            double bedrag = Double.parseDouble(AlleBedrag.get(0));
                                            for ( int i =0 ;i < AlleBedrag.size() ; i++){  
                                                bedrag =  Double.parseDouble(AlleBedrag.get(i));
                                                if (bedrag > max_bedrag) {
                                                    max_bedrag = bedrag ;
                                                    index_max_bedrag = i ;
                                                    }}
                                                    System.out.println("De grootste ontvangen inkomst =");
                                                    System.out.println("------------------------------------------------------");
                                                    System.out.format( " %12s € | %2s | %9s | %4s | %19s | %12s € | %12s €%n", 
                                                    AlleVorigTotaal.get(index_max_bedrag),
                                                    AlleDag.get(index_max_bedrag),
                                                    AlleMaand.get(index_max_bedrag),
                                                    AlleJaar.get(index_max_bedrag),
                                                    AlleBeschrijving.get(index_max_bedrag),
                                                    AlleBedrag.get(index_max_bedrag), 
                                                    AlleNieuwTotaal.get(index_max_bedrag));
                                                }
                                                else
                                                {
                                                    if (optionHoogsteRekeningStand.isSelected()){
                                                        int index_max_rekening = 0 ;
                                                        double max_rekeningstand = Double.parseDouble(AlleNieuwTotaal.get(0)) ;
                                                        double rekeningstand = Double.parseDouble(AlleNieuwTotaal.get(0));
                                                        for ( int i =0 ;i < AlleNieuwTotaal.size() ; i++){
                                                            rekeningstand =  Double.parseDouble(AlleNieuwTotaal.get(i));
                                                            if (rekeningstand > max_rekeningstand) {
                                                                max_rekeningstand = rekeningstand ;
                                                                index_max_rekening = i ;
                                                            }}
                                                            System.out.println(" De hoogste rekeningstand = ");
                                                            System.out.println("------------------------------------------------------");
                                                            System.out.format( " %12s € | %2s | %9s | %4s | %19s | %12s € | %12s €%n" , 
                                                            AlleVorigTotaal.get(index_max_rekening),
                                                            AlleDag.get(index_max_rekening) ,
                                                            AlleMaand.get(index_max_rekening) ,
                                                            AlleJaar.get(index_max_rekening) ,
                                                            AlleBeschrijving.get(index_max_rekening) ,
                                                            AlleBedrag.get(index_max_rekening) , 
                                                            AlleNieuwTotaal.get(index_max_rekening));
                                                           }
                                                           else
                                                            {
                                                                if (optionSortBedrag.isSelected()){
                                                                    double[] input  = {0,0,0,0,0,0,0,0,0,0,0,0,0}; // Aantal nullen moet minstens gelijk zijn aan het aantal bewerkingen
                                                                    for ( int i =0 ;i < AlleBedrag.size() ; i++){ 
                                                                        input[i] = Double.parseDouble(AlleBedrag.get(i));}
                                 
                                                                        BubbleSort.Bubble_Sort(input);
                             
                             
                                                                    }
                                                                    else
                                                                    {
                                                                        if (optionSortTotaal.isSelected()){
                                                                            double[] input = {0,0,0,0,0,0,0,0,0,0,0,0,0}; // Aantal nullen moet minstens gelijk zijn aan het aantal bewerkingen
                                                                            for ( int i =0 ;i < AlleNieuwTotaal.size() ; i++){ 
                                                                                input[i] = Double.parseDouble(AlleNieuwTotaal.get(i));}
                                                                                
                                                                                SelectionSort.doSelectionSort(input);
                                                                            
            }
        }
    }
}
}
}
        });
        }
        }
    }
}
} 
       });
       
        pack();
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLocationRelativeTo(null);
    }
class RadioButtonActionListener implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) 
        {
            JRadioButton button = (JRadioButton) event.getSource();
            if (button == optionNieuweBewerking) { } 
            else if (button == optionOverzichtBewerkingen) { }
            else if (button == optionStandRekening) { }
            else if (button == optionStatistiek) { }
            
        }
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                new RekeningenBasis().setVisible(true);
            }
        });
    }
}
