 


/**
 * klasse ECB - Berekening van eenparige cirkelvormige bewegingen
 *
 * @author (Wesley Creve)
 * @version (04/12/2015)
 */
public class ECB
{
    private static double vo; //Omtrekssnelheid | Eenheid: meter per seconde (m/s)
    private static double d; //Diametercirkel | Eenheid: meter
    private static double n; //Aantal toeren per minuut | Eenheid: minuten
    //Standaardformule: vo = (π.d.n)/60
    
    /**
     * Constructor voor klasse ECB
     */
    public ECB()
    {
        vo = 0;
        d = 0;
        n = 0;
    }


    /**
     * Berekent de omtrekssnelheid (vo) in m/s
     * 
     * @param d  diametercirkel (in meter)
     * @param n  toeren per minuut
     */
    public static void ECB_BerekenOmtrekssnelheid(double d, double n)
    {
        vo = (Math.PI*d*n)/60;
        System.out.println("Als de diametercirkel gelijk is aan " + d + " meter en het aantal toeren per minuut gelijk is aan " + n + " toeren, dan is de omtrekssnelheid " + vo + " m/s.");
    }
    
    /**
     * Berekent de diametercirkel (d) in meter
     * 
     * @param vo omtrekssnelheid (in m/s)
     * @param n  toeren per minuut
     */
    public static void ECB_BerekenDiametercirkel(double vo, double n)
    {
        d = (60*vo)/(Math.PI*n);
        System.out.println("Als de omtrekssnelheid gelijk is aan " + vo + " m/s en het aantal toeren per minuut gelijk is aan " + n + " toeren, dan is de grootte van de diametercirkel " + d + " meter.");
    }
    
    /**
     * Berekent het aantal toeren (n) per minuut en per seconde
     * 
     * @param vo omtrekssnelheid (in m/s)
     * @param d  diametercirkel (in meter)
     */
    public static void ECB_BerekenToeren(double vo, double d)
    {
        n = (60*vo)/(Math.PI*d);
        System.out.println("Als de omtrekssnelheid gelijk is aan " + vo + " m/s en de diametercirkel gelijk is aan " + d + " meter, dan zijn er " + n + " toeren per minuut of " + n/60 + " toeren per seconde.");
    }
}
