 


/**
 * klasse EVB - Berekening van veranderlijke versnelde bewegingen
 *
 * @author (Wesley Creve)
 * @version (04/12/2015)
 */
public class EVB
{
    private static double vt; //Eindsnelheid | Eenheid: meter per seconde (m/s)
    private static double v0; //Beginsnelheid | Eenheid: meter per seconde (m/s)
    private static double a; //Versnelling | Eenheid: meter per seconde² (m/s²)
    private static double t; //Tijd | Eenheid: seconde
    //Standaardformule: vt = v0 + a*t
    
    /**
     * Constuctor voor klasse EVB
     */
    public EVB()
    {
        vt = 0;
        v0 = 0;
        a = 0;
        t = 0;
    }

    /**
     * Berekent de eindsnelheid (vt) in m/s
     * 
     * @param v0  beginsnelheid (in m/s)
     * @param a  versnelling (in m/s²)
     * @param t  tijd (in seconden)
     */
    public static void EVB_BerekenEindSnelheid(double v0, double a, double t)
    {
        vt = v0 + a*t;
        System.out.println("Als de beginsnelheid gelijk is aan " + v0 + " m/s, de versnelling gelijk is aan " + a + " m/s² en de tijd " + t + " seconden bedraagt, dan is de eindsnelheid gelijk aan " + vt + " m/s.");
    }
    
    /**
     * Berekent de beginsnelheid (v0) in m/s
     * 
     * @param vt  eindsnelheid (in m/s)
     * @param a  versnelling (in m/s²)
     * @param t  tijd (in seconden)
     */
    public static void EVB_BerekenBeginSnelheid(double vt, double a, double t)
    {
        v0 = vt - a*t;
        System.out.println("Als de eindsnelheid gelijk is aan " + vt + " m/s, de versnelling gelijk is aan " + a + " m/s² en de tijd " + t + " seconden bedraagt, dan is de beginsnelheid gelijk aan " + v0 + " m/s.");
    }
    
    /**
     * Berekent de versnelling (a) in m/s²
     * 
     * @param v0  beginsnelheid (in m/s)
     * @param vt  eindsnelheid (in m/s)
     * @param t  tijd (in seconden)
     */
    public static void EVB_BerekenVersnelling(double v0, double vt, double t)
    {
        a = (vt - v0)/t;
        System.out.println("Als de beginsnelheid gelijk is aan " + v0 + " m/s, de eindsnelheid gelijk is aan " + vt + " m/s en de tijd " + t + " seconden bedraagt, dan is de versnelling gelijk aan " + a + " m/s².");
    }
    
    /**
     * Berekent de tijd (t) in seconden
     * 
     * @param v0  beginsnelheid (in m/s)
     * @param vt  eindsnelheid (in m/s)
     * @param a  versnelling (in m/s²)
     */
    public static void EVB_BerekenTijd(double v0, double a, double vt)
    {
        t = (vt - v0)/a;
        System.out.println("Als de beginsnelheid gelijk is aan " + v0 + " m/s, de versnelling gelijk is aan " + a + " m/s² en de eindsnelheid " + vt + " m/s bedraagt, dan is de tijd gelijk aan " + t + " seconden.");
    }
}
