
/**
 * klasse PW - Berekening van parallelle weerstanden
 *
 * @author (Wesley Creve)
 * @version (04/12/2015)
 */
public class PW
{
    private static double R1; //Eerste weerstand | Eenheid: ohm
    private static double R2; //Tweede weerstand | Eenheid: ohm
    private static double Rt; //Totale weerstand | Eenheid: ohm
    //Standaardformule: (1/Rt) = (1/R1) + (1/R2)
    
    /**
     * Constructor voor klasse PW
     */
    public PW()
    {
        R1 = 0;
        R2 = 0;
        Rt = 0;
    }

    
    /**
     * Berekent de totale weerstand (Rt) in ohm
     * 
     * @param R1  eerste weerstand (in ohm)
     * @param R2  tweede weerstand (in ohm)
     */
    public static void PW_BerekenTotWeerstand(double R1, double R2)
    {
        Rt = 1/((1/R1)+(1/R2));
        System.out.println("Als de eerste weerstand gelijk is aan " + R1 + " ohm en de tweede weerstand gelijk is aan " + R2 + " ohm, dan is de totale weerstand gelijk aan " + Rt + " ohm.");
    }
    
    /**
     * Berekent de eerste weerstand (R1) in ohm
     * 
     * @param R2  tweede weerstand (in ohm)
     * @param Rt  totale weerstand (in ohm)
     */
    public static void PW_BerekenWeerstand1(double Rt, double R2)
    {
        R1 = 1/((1/Rt)-(1/R2));
        System.out.println("Als de totale weerstand gelijk is aan " + Rt + " ohm en de tweede weerstand gelijk is aan " + R2 + " ohm, dan is de eerste weerstand gelijk aan " + R1 + " ohm.");
    }
    
    /**
     * Berekent de tweede weerstand (R2) in ohm
     * 
     * @param R1  eerste weerstand (in ohm)
     * @param Rt  totale weerstand (in ohm)
     */
    public static void PW_BerekenWeerstand2(double R1, double Rt)
    {
        R2 = 1/((1/Rt)-(1/R1));
        System.out.println("Als de totale weerstand gelijk is aan " + Rt + " ohm en de eerste weerstand gelijk is aan " + R1 + " ohm, dan is de tweede weerstand gelijk aan " + R2 + " ohm.");
    }
}
