
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
 
/**
 * Write a description of class TekenenMetDeMuis here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

public class TekenenMetDeMuis extends JComponent
{
      
    int mouseX_pressed, mouseY_pressed;
    int mouseX_dragged, mouseY_dragged;
    int mouseX_entered , mouseY_entered ;
    int mouseX_exited , mouseY_exited;
    int mouseX_clicked , mouseY_clicked;
    int mouseX_released , mouseY_released;
    boolean mouseDragged , mousePressed , mouseEntered ,mouseExited , mouseClicked , mouseReleased;
    boolean leftPressed;
    
 
    public static void main(String[] args) {
        SwingUtilities.invokeLater(( ) -> {
            createAndShowGUI(); 
        });
    }
 
    public TekenenMetDeMuis() {
        addMouseListener(myMouseAdapter);
        addMouseMotionListener(myMouseAdapter);
    }
     
    MouseAdapter myMouseAdapter = new MouseAdapter(){
 
        @Override
        public void mousePressed(MouseEvent e) {
            mouseX_pressed = e.getX();
            mouseY_pressed = e.getY();
            mouseDragged = false;
            mousePressed = true ;
            mouseEntered = false ;
            mouseExited = false ;
            mouseClicked = false ;
            mouseReleased = false ;
            if (SwingUtilities.isLeftMouseButton(e))
            {leftPressed = true;
            }
                else
                {
                leftPressed = false ;
            }
            repaint();
        }
 
        @Override
        public void mouseDragged(MouseEvent e) {
            mouseX_dragged = e.getX();
            mouseY_dragged = e.getY();
            mouseDragged = true;
            mousePressed = false  ;
            mouseEntered = false ;
            mouseExited = false ;
            mouseClicked = false ;
            mouseReleased = false ;
            repaint();
        }
        @Override
        public void mouseEntered(MouseEvent e) {
            mouseX_entered = e.getX();
            mouseY_entered = e.getY();
            mouseDragged = false;
            mousePressed = false  ;
            mouseEntered = true ; 
            mouseExited = false ;
            mouseClicked = false ;
            mouseReleased = false ;
            repaint();
        }
         @Override
        public void mouseExited(MouseEvent e) {
            mouseX_exited = e.getX();
            mouseY_exited = e.getY();
            mouseDragged = false;
            mousePressed = false  ;
            mouseEntered = false ; 
            mouseExited = true ;
            mouseClicked = false ;
            mouseReleased = false ;
            repaint();
        }
         @Override
        public void mouseClicked(MouseEvent e) {
            mouseX_clicked = e.getX();
            mouseY_clicked = e.getY();
            mouseDragged = false;
            mousePressed = false  ;
            mouseEntered = false ; 
            mouseExited = false ;
            mouseClicked = true ;
            mouseReleased = false ;
            repaint();
        }
         @Override
        public void mouseReleased(MouseEvent e) {
            mouseX_released = e.getX();
            mouseY_released = e.getY();
            mouseDragged = false;
            mousePressed = false  ;
            mouseEntered = false ; 
            mouseExited = false ;
            mouseClicked = false ;
            mouseReleased = true ;
            repaint();
        }
    };
    
    
 
    @Override
    /*
     * MouseDragged : teken een blauwe ovaal 
     * MousePressed : teken een kleine rode cirkel
     * MouseEntered :teken een groene rechthoek , met welkomstekst
     */
    public void paint(Graphics g) {
         
        Graphics2D tekeningMuis = (Graphics2D)g;
        tekeningMuis.setColor(Color.green);
        if(mouseDragged){
           
            int x, y;
            int w, h;
            if(mouseX_pressed > mouseX_dragged){
                x = mouseX_dragged;
                w = mouseX_pressed - mouseX_dragged;
            }else {
                x = mouseX_pressed;
                w = mouseX_dragged - mouseX_pressed;
            }
             
            if(mouseY_pressed > mouseY_dragged){
                y = mouseY_dragged;
                h = mouseY_pressed - mouseY_dragged;
            }else{
                y = mouseY_pressed;
                h = mouseY_dragged - mouseY_pressed;
            }
             
            tekeningMuis.fillOval(x, y, w, h);
            tekeningMuis.setColor(Color.black);
            tekeningMuis.drawOval(x, y, w, h);
        }
          else{
            if(mousePressed){
               if (leftPressed)
            { tekeningMuis.setColor(Color.blue);
              tekeningMuis.fillRect(mouseX_pressed-5, mouseY_pressed-5, 80, 80);
                }
             else
              { tekeningMuis.setColor(Color.yellow);
                 tekeningMuis.fillOval(mouseX_pressed-5, mouseY_pressed-5, 80, 80); 
                }
          }
            else {
             if (mouseEntered)
             { 
               tekeningMuis.setColor(Color.yellow);
               tekeningMuis.fillRect(0 , 0 ,700, 400);
               tekeningMuis.setColor(Color.black);
               tekeningMuis.drawString("Welkom tot de oefening met muisoperaties", 20 , 20  );
               tekeningMuis.setColor(Color.blue);
               tekeningMuis.drawString("Gemaakt door Elien Van Asbroeck op 18/02/2016", 20 , 40  );
                } 
                else{
                if (mouseExited)
                {tekeningMuis.setColor(Color.blue);
                 tekeningMuis.fillRect(0,0,600,600);
                 tekeningMuis.setColor(Color.black);
                 tekeningMuis.drawString("Dank je wel en tot de volgende keer", 20, 20);
                 
                }
                 else{
                      if (mouseClicked)
                      {tekeningMuis.setColor(Color.red);
                       tekeningMuis.drawString("Muis klik op plaats x,y", mouseX_clicked , mouseY_clicked);
                        }
                          else{
                              if (mouseReleased)
                              {tekeningMuis.setColor(Color.red);
                               int[]x={mouseX_released, mouseX_released, mouseX_released+100};
                               int[]y={mouseY_released,mouseY_released-100,mouseY_released};
                               tekeningMuis.fillPolygon(x,y,3);
                                }
                            }
                        }
            }
        }
    }
}
 
    private static void createAndShowGUI() {
        JFrame myFrame = new JFrame();
        myFrame.setTitle("www.elienvanasbroeck.com");
        myFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        myFrame.setSize(new Dimension(600, 600));
        myFrame.setLayout(new BorderLayout());
        myFrame.add(new TekenenMetDeMuis(), BorderLayout.CENTER);
        myFrame.setVisible(true);
    }
}

