  
  
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
 
/**
 * Write a description of class TekenenMetDeMuis here.
 * 
 * Jozef Aerts
 * @version (a version number or a date)
 */
public class TekenenMetDeMuis extends JComponent
{
      
    int mouseX_pressed, mouseY_pressed;
    int mouseX_dragged, mouseY_dragged;
    int mouseX_entered , mouseY_entered ;
    int mouseX_released , mouseY_released ;
    int mouseX_exited , mouseY_exited ;
    boolean mouseDragged , mousePressed , mouseEntered , mouseReleased , mouseExited;
 
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
 
    public TekenenMetDeMuis() {
        addMouseListener(myMouseAdapter);
        addMouseMotionListener(myMouseAdapter);
    }
     
    MouseAdapter myMouseAdapter = new MouseAdapter(){
 
        @Override
        public void mousePressed(MouseEvent e) {
            mouseX_pressed = e.getX();
            mouseY_pressed = e.getY();
            mouseDragged = false;
            mousePressed = true ;
            mouseEntered = false ;
            mouseReleased = false ;
            mouseExited = false ;
            repaint();
        }
        @Override
        public void mouseDragged(MouseEvent e) {
            mouseX_dragged = e.getX();
            mouseY_dragged = e.getY();
            mouseDragged = true;
            mousePressed = false  ;
            mouseEntered = false ;
            mouseReleased = false ;
            mouseExited = false ;
            repaint();
        }
        @Override
        public void mouseEntered(MouseEvent e) {
            mouseX_entered = e.getX();
            mouseY_entered = e.getY();
            mouseDragged = false;
            mousePressed = false  ;
            mouseEntered = true ;
            mouseReleased = false ;
            mouseExited = false ;
            repaint();
        }
         @Override
        public void mouseReleased(MouseEvent e) {
            mouseX_released = e.getX();
            mouseY_released = e.getY();
            mouseDragged = false;
            mousePressed = false ;
            mouseEntered = false ;
            mouseReleased = true ;
            mouseExited = false ;
            repaint();
        }
         @Override
        public void mouseExited(MouseEvent e) {
            mouseX_exited = e.getX();
            mouseY_exited = e.getY();
            mouseDragged = false;
            mousePressed = false ;
            mouseEntered = false ;
            mouseReleased = false ;
            mouseExited = true ;
            repaint();
        }
    };
 
    @Override
    /*
     * MouseDragged : teken een blauwe ovaal 
     * MousePressed : teken een kleine rode cirkel
     * MouseEntered :teken een groene rechthoek , met welkomstekst
     */
    public void paint(Graphics g) {
         
        Graphics2D tekeningMuis = (Graphics2D)g;
        tekeningMuis.setColor(Color.blue);
        if(mouseDragged){
           
            int x, y;
            int w, h;
            if(mouseX_pressed > mouseX_dragged){
                x = mouseX_dragged;
                w = mouseX_pressed - mouseX_dragged;
            }else {
                x = mouseX_pressed;
                w = mouseX_dragged - mouseX_pressed;
            }
             
            if(mouseY_pressed > mouseY_dragged){
                y = mouseY_dragged;
                h = mouseY_pressed - mouseY_dragged;
            }else{
                y = mouseY_pressed;
                h = mouseY_dragged - mouseY_pressed;
            }
             
            tekeningMuis.drawOval(x, y, w, h);
        }else{
         if(mousePressed)
            {
            tekeningMuis.setColor(Color.red);
            tekeningMuis.fillOval(mouseX_pressed-5, mouseY_pressed-5, 20, 20);
            }
          if(mouseReleased)
            {
            tekeningMuis.setColor(Color.blue);
            tekeningMuis.fillRect(10 , 20 ,300, 500);
            tekeningMuis.setColor(Color.white);
            tekeningMuis.fillRect(310 , 20, 300, 500);
            tekeningMuis.setColor(Color.red);
            tekeningMuis.fillRect(610 , 20, 300, 500);
            }
         else {
             if (mouseEntered)
             { 
              tekeningMuis.setColor(Color.black);
              tekeningMuis.fillRect(10 , 20 ,300, 500);
              tekeningMuis.setColor(Color.yellow);
              tekeningMuis.fillRect(310 , 20, 300, 500);
              tekeningMuis.setColor(Color.red);
              tekeningMuis.fillRect(610 , 20, 300, 500);
              tekeningMuis.setColor(Color.blue);
              tekeningMuis.drawString("Gemaakt door Jozef Aerts", 10 , 10  );
                } 
         
             if (mouseExited)
             {
              tekeningMuis.setColor(Color.blue);
              tekeningMuis.fillRect(10 , 20 ,900, 500);
              tekeningMuis.setColor(Color.white);
              tekeningMuis.fillRect(10 , 210 ,900, 120);
              tekeningMuis.setColor(Color.white);
              tekeningMuis.fillRect(250 , 20 ,120, 500);
              tekeningMuis.setColor(Color.red);
              tekeningMuis.fillRect(10 , 230 ,900, 80);
              tekeningMuis.setColor(Color.red);
              tekeningMuis.fillRect(270 , 20 ,80, 500);
            }
        }  
     }
    }
    
 
    private static void createAndShowGUI() {
        JFrame myFrame = new JFrame();
        myFrame.setTitle("muis-operaties met vlaggen       Jozef Aerts" );
        myFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        myFrame.setSize(new Dimension(1000, 900));
        myFrame.setLayout(new BorderLayout());
        myFrame.add(new TekenenMetDeMuis(), BorderLayout.CENTER);
        myFrame.setVisible(true);
    }
}

